/*
 *      #####################################################################
 *
 *        
 *        This software is provided 'as is', without warranty of any kind,
 *        express or implied. In no event shall the author be held liable
 *        for any damages arising from the use of this software.
 *
 *        Permission to use, copy, modify, and distribute this software and
 *        its documentation for non-commercial purposes is hereby granted,
 *        provided that the above copyright notice and this disclaimer appear
 *        in all copies and supporting documentation.
 *
 *        The software must NOT be sold or used as part of a any commercial
 *        or "non-free" product.
 *
 *      #####################################################################
 */

#include <windows.h>
#include <windowsx.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "main.h"

// Globals
extern char filename[];
extern char image_name[];
extern char full_incoming_path[];
extern char path_plus_filename[];
extern char full_image_path[];
extern HWND hwnd, hCtl_TX;

extern BOOL SMALL_PIC;
extern BOOL LARGE_PIC;
extern BOOL VERYLARGE_PIC;
extern BOOL FAX;

extern BOOL Remote_webcam;
								                   


//********************************************************************************************************************************************
//Directed call "Read message to file" command

int extractFilename(unsigned char **ppMsgBuf, unsigned char *filename, unsigned char *rcvdCall, unsigned char *rspData)
{
    unsigned char *msgBuf;
    filename[0] = '\0';

    msgBuf = *ppMsgBuf;

    if (*msgBuf != '[') //If we find the opening bracket, search for the closing one...
    {
        // default file
        sprintf(filename, "%s", rcvdCall);
    }
    else
    {
        msgBuf++;
        // look for closing ']'
        char *p = strchr(msgBuf, ']');
        if (p != 0)
        {
            // found ]
            *p = (char)0;   // null terminate the filename
            sprintf(filename, "%s", msgBuf);
        }
        else
        {
            // ill formed command. Send NAK back.
            sprintf(rspData, " nak: missing ]");
            return 0;
        }

    }
    return 1;
}

//********************************************************************************************************************************************
//Directed call "Read message to file" command

void directCmdReadFile(unsigned char *msgBuf, unsigned char *rcvdCall)
{
    int defaultFilename = 0;
    char rsp_data[4096];    // data to send back to requesting station.
    filename[0] = '\0';
    FILE *file = 0;

    memset(rsp_data, 0, 4096);

    extractFilename(&msgBuf, filename, rcvdCall, rsp_data);
    defaultFilename = strstr((const char *)rcvdCall, (char *)filename) != 0 ? 1 : 0;

        // look for illegal characters \ and /
        char *q = strchr(filename, '\\'); //Note: this is actually only \ but need the reserved escape char \ in the function (tricky)
        char *r = strchr(filename, '/');
        if ((q != 0)|(r != 0))
        {
            // found illegal chars
            sprintf(rsp_data, " Illegal filename");
		    goto send_response;
        }

//extract the actual filename, leaving out the header (%S, %L etc)
//	char image_name[80];
//	wchar_t image[255] ;

//    image_name[0] = '\0';
//	strcpy(&image_name[0], &filename[2]);

//	mbstowcs(image, &filename[2], 80);
        
		//   MessageBoxW (hwnd,image,L"tcaption",MB_OK	);  //test for correct wide char syntax

// Check to see if the file requested is an image file

//First test for to see if the image file requested exists.
		if(strstr(&filename[0],"%")!=0)      //if the message is of the form [%....]
			{
				sprintf(path_plus_filename,"%s\\%s",full_image_path,&filename[2]); //add the path to "Shared/Images" folder 
				file = fopen(path_plus_filename, "r");
            	if (file != 0)
        		{
			 		fclose(file);//nothing else to do here; file exists, keep moving
				}
					else
				{
            	 	sprintf(rsp_data, " nak: file %s doesn't exist.", &filename[2]);
            	 	fclose(file);
			 		goto send_response;
        		}
			}

// Now look for the image trigger, %, and image size, S,L etc   ie. if the message is of the form [%S.....]
		if(strstr(&filename[0],"%S")!=0)
		{
			SMALL_PIC 		= TRUE;
			LARGE_PIC 		= FALSE;
			VERYLARGE_PIC 	= FALSE;
			FAX 			= FALSE;
			int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);             
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)rcvdCall);  //Must put return call in here as can't "extern" it to image.c			
			len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
			SendMessage(hCtl_TX, EM_SETSEL, len, len);
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"% S");
		    
			SendMessage(hwnd, WM_COMMAND,IDC_REMOTE_SEND_PIC_BUTTON,0);
			return 0;
		}
		if(strstr(&filename[0],"%L")!=0)  
		{
			SMALL_PIC 		= FALSE;
			LARGE_PIC 		= TRUE;
			VERYLARGE_PIC 	= FALSE;
			FAX 			= FALSE;
			int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);             
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)rcvdCall);  //Must put return call in here as can't "extern" it to image.c			
			len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
			SendMessage(hCtl_TX, EM_SETSEL, len, len);
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"% L");
		    
			SendMessage(hwnd, WM_COMMAND,IDC_REMOTE_SEND_PIC_BUTTON,0);
			return 0;
		}
		if(strstr(&filename[0],"%V")!=0)  
		{
			SMALL_PIC 		= FALSE;
			LARGE_PIC 		= FALSE;
			VERYLARGE_PIC 	= TRUE;
			FAX 			= FALSE;
			int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);             
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)rcvdCall);  //Must put return call in here as can't "extern" it to image.c			
			len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
			SendMessage(hCtl_TX, EM_SETSEL, len, len);
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"% V");
		    
			SendMessage(hwnd, WM_COMMAND,IDC_REMOTE_SEND_PIC_BUTTON,0);
			return 0;
		}
		if(strstr(&filename[0],"%F")!=0)  
		{
			SMALL_PIC 		= FALSE;
			LARGE_PIC 		= FALSE;
			VERYLARGE_PIC 	= FALSE;
			FAX 			= TRUE;
			int len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);             
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)rcvdCall);  //Must put return call in here as can't "extern" it to image.c			
			len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
			SendMessage(hCtl_TX, EM_SETSEL, len, len);
			SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)"% F");
		    
			SendMessage(hwnd, WM_COMMAND,IDC_REMOTE_SEND_PIC_BUTTON,0);
			return 0;
		}


//Back to text file stuff if there is no image to retrieve
     
    if (strlen(filename) > 0)
    {
		//Append the secure path to the filename, as that is the only folder where files can be requested
        sprintf(path_plus_filename,"%s\\%s",full_incoming_path,filename); //add the path to "Shared" folder
        file = fopen(path_plus_filename, "r");

        if (file != 0)
        {
            if (defaultFilename)
                sprintf(rsp_data, " [Msg Pickup] ", path_plus_filename);
            else
                sprintf(rsp_data, "#[%s]", filename);//(now sends filename in a format that can be saved as a file)  old version ->  sprintf(rsp_data, " [File %s] ", filename);
            fread(&rsp_data[strlen(rsp_data)], 1, 4000, file); // only read 4000 into buffer 
            if (ferror(file))
                sprintf(rsp_data, " nak: error reading file '%s'.", filename);
            else
            fclose(file);
        }
        else
        {
            // file doesn't exist. respond w/ NAK error
            if (defaultFilename)
                sprintf(rsp_data, " No file for your station.", filename);
            else
                sprintf(rsp_data, " nak: file %s doesn't exist.", filename);
        }
    }
send_response:

    //Send file (or NAK) back to originating station
    KillTimer(hwnd, 1); //Stop the timer if it has failed to send a reply message
    SetFocus(hCtl_TX);

    int len;

    SendMessage(hCtl_TX, EM_REPLACESEL, 0, (LPARAM)rcvdCall);   //send the message to the TX box ready to transmit
    len = SendMessage(hCtl_TX, WM_GETTEXTLENGTH, 0, 0);
    SendMessage(hCtl_TX, EM_REPLACESEL, len, (LPARAM)rsp_data);

    srand((int)clock());
    int starts = 500 + rand() % 3000;
    SetTimer(hwnd, 1, starts, NULL);    //Start a timer and then TX after squelch has closed  
}


